import os
import gzip

assembly = "hg38"

def timestamp(filename):
    import time, os
    t = os.path.getmtime(filename)
    return time.strftime("%Y.%m.%d", time.localtime(t))


directory = "/osc-fs_home/mdehoon/Data/UCSC/tRNA"
filename = "tRNA.txt.gz"
path = os.path.join(directory, assembly, filename)
time = timestamp(path)
print("Reading", path)
stream = gzip.open(path, 'rt')
filename = "tRNA.gff"
print("Writing", filename)
output = open(filename, 'w')
source = "UCSC:tRNAscan-SE"
output.write("##source-version %s %s\n" % (source, time))
for line in stream:
    if line.startswith("#"):
        continue
    words = line.split()
    chromosome = words[1]
    start = int(words[2])
    end = int(words[3])
    strand = words[6]
    aminoacid = words[7]
    if aminoacid=='SeC(e)':
        aminoacid = 'SeC'
    anticodon = words[8]
    output.write("%s\tUCSC\ttRNA|%s%s\t%d\t%d\t.\t%s\t.\t.\n" % (chromosome, aminoacid, anticodon, start+1, end, strand))
stream.close()
output.close()
